/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modulesclient;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mcjty.lib.client.RenderHelper;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsutility.modules.screen.modules.ElevatorButtonScreenModule;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class ElevatorButtonClientScreenModule
implements IClientScreenModule<ElevatorButtonScreenModule.ModuleElevatorInfo> {
    public static final int LARGESIZE = 22;
    public static final int SMALLSIZE = 16;
    private int buttonColor = 0xFFFFFF;
    private int currentLevelButtonColor = 0xFFFF00;
    private boolean vertical = false;
    private boolean large = false;
    private boolean lights = false;
    private boolean start1 = false;
    private final String[] levels = new String[8];

    public IClientScreenModule.TransformMode getTransformMode() {
        return IClientScreenModule.TransformMode.TEXT;
    }

    public int getHeight() {
        if (this.vertical) {
            return this.large ? 110 : 112;
        }
        return this.large ? 22 : 16;
    }

    private int getDimension() {
        return this.large ? 22 : 16;
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, IModuleRenderHelper renderHelper, Font fontRenderer, int currenty, ElevatorButtonScreenModule.ModuleElevatorInfo screenData, ModuleRenderInfo renderInfo) {
        if (screenData == null) {
            return;
        }
        int currentLevel = screenData.getLevel();
        int buttons = screenData.getMaxLevel();
        BlockPos pos = screenData.getPos();
        List<Integer> heights = screenData.getHeights();
        if (this.vertical) {
            this.renderButtonsVertical(matrixStack, buffer, renderHelper, currenty, currentLevel, buttons, pos, heights, renderInfo);
        } else {
            this.renderButtonsHorizontal(matrixStack, buffer, renderHelper, currenty, currentLevel, buttons, pos, heights, renderInfo);
        }
    }

    private void renderButtonsHorizontal(PoseStack matrixStack, MultiBufferSource buffer, IModuleRenderHelper renderHelper, int currenty, int currentLevel, int buttons, BlockPos pos, List<Integer> heights, ModuleRenderInfo renderInfo) {
        int max;
        int xoffset = 5;
        int n = max = this.large ? 6 : 9;
        if (buttons > max) {
            buttons = max;
        }
        for (int i = 0; i < buttons; ++i) {
            boolean hasText;
            String text = this.getLevelText(i, pos, heights);
            boolean bl = hasText = text != null;
            if (text == null) {
                text = String.valueOf(i + (this.start1 ? 1 : 0));
            }
            int col = i == currentLevel ? this.currentLevelButtonColor : this.buttonColor;
            int textoffset = this.large ? 3 : 0;
            int x = xoffset + 3 + textoffset;
            int y = currenty + 2 + textoffset;
            if (this.lights) {
                RenderHelper.drawBeveledBox((PoseStack)matrixStack, (MultiBufferSource)buffer, (int)xoffset, (int)currenty, (int)(xoffset + this.getDimension() - 4), (int)(currenty + this.getDimension() - 2), (int)-1, (int)-1, (int)(-16777216 + col), (int)renderInfo.getLightmapValue());
                if (hasText) {
                    renderHelper.renderTextTrimmed(matrixStack, buffer, x, y, 0xFFFFFF, renderInfo, text, 480);
                }
            } else {
                RenderHelper.drawBeveledBox((PoseStack)matrixStack, (MultiBufferSource)buffer, (int)xoffset, (int)currenty, (int)(xoffset + this.getDimension() - 4), (int)(currenty + this.getDimension() - 2), (int)-1118482, (int)-13421773, (int)-10066330, (int)renderInfo.getLightmapValue());
                renderHelper.renderTextTrimmed(matrixStack, buffer, x, y, col, renderInfo, text, (this.getDimension() - 4) * 4);
            }
            xoffset += this.getDimension() - 2;
        }
    }

    private void renderButtonsVertical(PoseStack matrixStack, MultiBufferSource buffer, IModuleRenderHelper renderHelper, int currenty, int currentLevel, int buttons, BlockPos pos, List<Integer> heights, ModuleRenderInfo renderInfo) {
        int max = this.large ? 6 : 8;
        int y = currenty;
        int numcols = (buttons + max - 1) / max;
        int w = ElevatorButtonScreenModule.getColumnWidth(numcols);
        for (int i = 0; i < buttons; ++i) {
            boolean hasText;
            int level = buttons - i - 1;
            int column = level / max;
            int xoffset = 5 + (w + 7) * column;
            String text = this.getLevelText(level, pos, heights);
            boolean bl = hasText = text != null;
            if (text == null) {
                text = String.valueOf(level + (this.start1 ? 1 : 0));
            }
            int col = level == currentLevel ? this.currentLevelButtonColor : this.buttonColor;
            int textoffset = this.large ? 3 : 0;
            int x = xoffset + 3 + textoffset;
            int yy = y + 2 + textoffset;
            if (this.lights) {
                RenderHelper.drawBeveledBox((PoseStack)matrixStack, (MultiBufferSource)buffer, (int)xoffset, (int)y, (int)(xoffset + w), (int)(y + this.getDimension() - 2), (int)-1, (int)-1, (int)(-16777216 + col), (int)renderInfo.getLightmapValue());
                if (hasText) {
                    renderHelper.renderTextTrimmed(matrixStack, buffer, x, yy, 0xFFFFFF, renderInfo, text, w * 4);
                }
            } else {
                RenderHelper.drawBeveledBox((PoseStack)matrixStack, (MultiBufferSource)buffer, (int)xoffset, (int)y, (int)(xoffset + w), (int)(y + this.getDimension() - 2), (int)-1118482, (int)-13421773, (int)-10066330, (int)renderInfo.getLightmapValue());
                renderHelper.renderTextTrimmed(matrixStack, buffer, x, yy, col, renderInfo, text, w * 4);
            }
            y += this.getDimension() - 2;
            if (level % max != 0) continue;
            y = currenty;
        }
    }

    private String getLevelText(int level, BlockPos pos, List<Integer> heights) {
        if (this.hasLevelText(level)) {
            return this.levels[level];
        }
        if (level < heights.size()) {
            // empty if block
        }
        return null;
    }

    private boolean hasLevelText(int i) {
        return i < this.levels.length && this.levels[i] != null && !this.levels[i].isEmpty();
    }

    public void mouseClick(Level world, int x, int y, boolean clicked) {
    }

    public void setupFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        if (tagCompound != null) {
            this.buttonColor = tagCompound.m_128441_("buttonColor") ? tagCompound.m_128451_("buttonColor") : 0xFFFFFF;
            this.currentLevelButtonColor = tagCompound.m_128441_("curColor") ? tagCompound.m_128451_("curColor") : 0xFFFF00;
            this.vertical = tagCompound.m_128471_("vertical");
            this.large = tagCompound.m_128471_("large");
            this.lights = tagCompound.m_128471_("lights");
            this.start1 = tagCompound.m_128471_("start1");
            for (int i = 0; i < this.levels.length; ++i) {
                this.levels[i] = tagCompound.m_128441_("l" + i) ? tagCompound.m_128461_("l" + i) : null;
            }
        }
    }

    public boolean needsServerData() {
        return true;
    }
}

